<?php
include('db.php');

// Query untuk menampilkan produk
$sql = "SELECT * FROM produk";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Produk - Toko Oleh-Oleh</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <h1>Toko Oleh-Oleh</h1>
        <nav>
            <ul>
                <li><a href="profil.php">Profil Usaha</a></li>
                <li><a href="add_product.php">Tambah Produk</a></li>
            </ul>
        </nav>
    </header>

    <section>
        <h2>Daftar Produk</h2>
        <table>
            <tr>
                <th>Nama Produk</th>
                <th>Jenis Produk</th>
                <th>Harga</th>
                <th>Stok</th>
                <th>Aksi</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $row['nama_produk']; ?></td>
                <td><?php echo $row['jenis_produk']; ?></td>
                <td>Rp <?php echo number_format($row['harga_produk'], 0, ',', '.'); ?></td>
                <td><?php echo $row['stok_produk']; ?></td>
                <td>
                    <a href="edit_product.php?id=<?php echo $row['id_produk']; ?>">Edit</a> |
                    <a href="delete_product.php?id=<?php echo $row['id_produk']; ?>">Hapus</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </table>
    </section>
</body>
</html>
